classdef  testAssemble_components < matlab.unittest.TestCase
    %TESTASSEMBLE_COMPONENTS Test protected method for checking indices
    
    methods(Test)
        
        function testEmpty(testCase)
            p = polysym.empty;
            testCase.verifyTrue(isempty(p.assemble_components))
        end
        
        function testDefault(testCase)
            p = polysym;
            testCase.verifyEqual(p.assemble_components,{p})
        end
        
        function testSingleChar(testCase)
            p = polysym('x');
            testCase.verifyEqual(p.assemble_components,{p})
        end
        
        function testSingleArray(testCase)
            p = polysym('x',[2 3]);
            testCase.verifyEqual(p.assemble_components,{p})
        end
        
        function testIncompleteArray(testCase)
            polysyms('x1_2','x2_3')
            p = [x1_2 x2_3];
            testCase.verifyEqual(p.assemble_components,{p(1), p(2)})
        end
        
        function testColumnVector(testCase)
            p = polysym('x',[3 1]);
            testCase.verifyEqual(p.assemble_components,{p})
        end
        
        function testRowVector(testCase)
            p = polysym('x',[1 3]);
            testCase.verifyEqual(p.assemble_components,{p(:)})
        end
        
        function testVectorIncomplete(testCase)
            polysyms('x1','x3')
            p = [x1 x3];
            testCase.verifyEqual(p.assemble_components,{p(1),p(2)})
        end
        
        function testMultipleChars(testCase)
            polysyms('x','y')
            p = [x y];
            testCase.verifyEqual(p.assemble_components,{x,y})
        end
        
        function testMixed(testCase)
            % If there is more than one array, they are returned as a list of
            % components.
            polysyms('x')
            p = polysym('w',2);
            v = [p(:); x];
            testCase.verifyEqual(v.assemble_components,{p(1);p(2);p(3);p(4);x})
        end
        
        function testOverlap(testCase)
            % Repetitions in terms are ignored.
            polysyms x1 x2 x3
            v = [x1 x2 x2 x3];
            testCase.verifyEqual(v.assemble_components,{[x1; x2; x3]})
        end
        
        function testZeroIndex(testCase)
            polysyms l0 l1
            v = [l0 l1];
            testCase.verifyEqual(v.assemble_components,{l0 l1})
            
        end
    end
end
