classdef test_solve < matlab.unittest.TestCase
    %Test BertiniLab solve method
    
    methods(Test)
        
        function testBasicExample(testCase)
            polysyms('x','y')
            obj = BertiniLab('function_def',[x^2-1; x+y-1],'variable_group',[x y]);
            obj = solve(obj);
            testCase.verifyTrue(~isempty(strfind(obj.solve_summary,'Paths Tracked: 2')))
            real_finite_solutions = obj.read_solutions('real_finite_solutions');
            testCase.verifyEqual(double(real_finite_solutions),[1 -1; 0 2],'AbsTol',1e-12)
        end
        
        function testBadInputFile(testCase)
            polysyms('x','y')
            obj = BertiniLab('function_def',y,'variable_group',x);
            f = @() obj.solve;
            testCase.verifyError(f,'BertiniLab:solve:callFailed')
        end
    end
    
    methods(TestMethodTeardown)
        function teardown(~)
            BertiniClean
        end
    end
end