classdef test_sharpen < matlab.unittest.TestCase
    %Test the solution sharpening method.
    
    properties
        poly_sys
    end
    methods(TestMethodSetup)
        function nameFiles(testCase)
            BertiniClean
            
            polysyms x y
            hyperbola = x^2 - y^2 - 1;
            parabola = x - y^2 - 1;
            
            ps = BertiniLab('function_def',[hyperbola; parabola],'variable_group',[x y]);
            testCase.poly_sys = solve(ps);
        end
    end
    methods(Test)
        function testNoFile(testCase)
            opts = struct('endpoint_selection','nonexistent_file');
            f = @() testCase.poly_sys.sharpen(opts);
            testCase.verifyError(f,'BertiniLab:sharpen:fileNotFound')
        end
        function testInputFile(testCase)
            opts = struct('endpoint_selection','sharpening_test_input');
            ps = testCase.poly_sys.sharpen(opts);
            testCase.verifyNotEmpty(strfind(ps.solve_summary,'Endpoints Considered for Sharpening: 1'))
        end
        function testManualSelection(testCase)
            opts = struct('endpoint_selection',3);
            ps = testCase.poly_sys.sharpen(opts);
            testCase.verifyNotEmpty(strfind(ps.solve_summary,'Sharpening path number 3'))
        end
        function testNoOpts(testCase)
            ps = testCase.poly_sys.sharpen;
            testCase.verifyNotEmpty(strfind(ps.solve_summary,'Endpoints Considered for Sharpening: 4'))
        end
        function testInvalidMethod(testCase)
            opts = struct('sharpening_method','newbie');
            f = @() testCase.poly_sys.sharpen(opts);
            testCase.verifyError(f,'BertiniLab:sharpen:invalidInput')
        end
        function testNewton(testCase)
            opts = struct('sharpening_method','newton');
            ps = testCase.poly_sys.sharpen(opts);
            testCase.verifyNotEmpty(strfind(ps.solve_summary,'Sharpening method:'))
        end
        function testEndgame(testCase)
            opts = struct('sharpening_method','Endgame');
            ps = testCase.poly_sys.sharpen(opts);
            testCase.verifyNotEmpty(strfind(ps.solve_summary,'currently an endgame approach'))
        end
        function testEndgameRegeneration(testCase)
            opts = struct('sharpening_method','Endgame');
            ps = testCase.poly_sys;
            ps.config.UseRegeneration = 1;
            f = @() ps.sharpen(opts);
            testCase.verifyError(f,'BertiniLab:sharpen:invalidConfiguration')
        end
        function testEndgameDiagonal(testCase)
            opts = struct('sharpening_method','Endgame');
            ps = testCase.poly_sys;
            ps.config.UseDiagonal = 1;
            f = @() ps.sharpen(opts);
            testCase.verifyError(f,'BertiniLab:sharpen:invalidConfiguration')
        end

        function testEndgameTooSharp(testCase)
            opts = struct('sharpening_method','Endgame');
            ps = testCase.poly_sys;
            ps.config.SharpenDigits = 301;
            f = @() ps.sharpen(opts);
            testCase.verifyError(f,'BertiniLab:sharpen:invalidConfiguration')
        end
    end
    methods(TestMethodTeardown)
        function teardown(~)
            BertiniClean
        end
    end
end