classdef test_mat2struct < matlab.unittest.TestCase
    %Test the method for converting matrices to structures
    
    properties
        vector_system
        one_var_system
        two_var_system
    end
    methods(TestMethodSetup)
        function nameFiles(testCase)
            BertiniClean
            
            polysyms('z')
            testCase.one_var_system = BertiniLab('function_def',z^2-1, ...
                'variable_group',z);
            
            polysyms('x','y')
            testCase.two_var_system = BertiniLab('function_def',[x^2-1; x+y-1], ...
                'variable_group',[x y]);
            
            v = polysym('v',[2 1]);
            polysyms lambda
            eig_equation = [1 2; 3 4]*v - eye(2)*lambda;
            testCase.vector_system = BertiniLab('function_def',eig_equation, ...
                'variable_group',lambda,'hom_variable_group',v);
        end
    end
    
    methods(Test)
        function testNoArguments(testCase)
            f = @() testCase.two_var_system.mat2struct;
            testCase.verifyError(f,'MATLAB:minrhs')
        end
        
        function testInvalidData(testCase)
            f = @() testCase.two_var_system.mat2struct(struct);
            testCase.verifyError(f,'MATLAB:mat2struct:invalidType')
        end
        
        function testOneVariableRowVector(testCase)
            x = 0:2;
            actual = testCase.one_var_system.mat2struct(x);
            expected = struct('z',polysym(x));
            testCase.verifyEqual(actual,expected)
        end
        
        function testOneVariableColumnVector(testCase)
            x = 0:2;
            f = @() testCase.one_var_system.mat2struct(x.');
            testCase.verifyError(f,'BertiniLab:dehomogenize:wrongSize')
        end
        
        function testTwoVariablesColumnVector(testCase)
            actual = testCase.two_var_system.mat2struct([1; 2]);
            expected = struct('x',polysym(1),'y',polysym(2));
            testCase.verifyEqual(actual,expected)
        end
        
        function testTwoVariablesRowVector(testCase)
            actual = testCase.two_var_system.mat2struct([1 2]);
            expected = struct('x',polysym(1),'y',polysym(2));
            testCase.verifyEqual(actual,expected)
        end
        
        function testVectorSystem(testCase)
            actual = testCase.vector_system.mat2struct([1; 2; 3]);
            expected = struct('lambda',polysym(1),'v',polysym([2; 3]));
            testCase.verifyEqual(actual,expected)
        end
    end
    
    methods(TestMethodTeardown)
        function teardown(~)
            BertiniClean
        end
    end
end