classdef test_make_param_file < matlab.unittest.TestCase
%TEST_MAKE_PARAM_FILE Test the method for making parameter files

    properties
        params = {[1 1i],polysym([1 1i])};
        param_file_names = {'start_parameters','final_parameters'};
    end
    methods(TestMethodSetup)
        function setup(testCase)
            % Delete the input file, if it exists
            warning('off','MATLAB:DELETE:FileNotFound')
            delete(testCase.param_file_names{:});
            warning('on','MATLAB:DELETE:FileNotFound')
        end
    end
    
    methods(Test)
        function testNoData(testCase)
            obj = BertiniLab;
            f = @() make_param_file(obj);
            testCase.verifyError(f,'MATLAB:minrhs')
        end
        
        function testNoFileName(testCase)
            obj = BertiniLab;            
            f = @() make_param_file(obj,polysym(0));
            testCase.verifyError(f,'MATLAB:minrhs')
        end
        
        function testMinimalStart(testCase)
            obj = BertiniLab;
            
            for ii=1:length(testCase.params)
                for jj=1:length(testCase.param_file_names)
                    s = obj.make_param_file(testCase.params{jj},testCase.param_file_names{ii});
                    testCase.verifyEqual(s,testCase.param_file_names{ii})
                    
                    fid = fopen(testCase.param_file_names{ii});
                    n = fscanf(fid,'%d\n\n',1);
                    testCase.verifyEqual(n,numel(testCase.params{jj}))
                    x = fscanf(fid,'%d %d\n',[n n]);
                    testCase.verifyEqual(x,[1 0; 0 1])
                    fclose(fid);
                end
            end
        end
        
    end
    
    methods(TestMethodTeardown)
        function teardown(testCase)
            % Delete the input file, if it exists
            warning('off','MATLAB:DELETE:FileNotFound')
            delete(testCase.param_file_names{:});
            warning('on','MATLAB:DELETE:FileNotFound')
        end
    end
end
