classdef test_make_data_file < matlab.unittest.TestCase
%TEST_MAKE_DATA_FILE Test the method for making data files

    properties
        data = {0, polysym(0), struct('x',polysym(0))};
        data_file_names = {'start','member_points'};
    end
    methods(TestMethodSetup)
        function setup(testCase)
            % Delete the input file, if it exists
            warning('off','MATLAB:DELETE:FileNotFound')
            delete(testCase.data_file_names{:});
            warning('on','MATLAB:DELETE:FileNotFound')
        end
    end
    
    methods(Test)
        function testNoData(testCase)
            obj = BertiniLab('variable_group',polysym('x'));
            
            f = @() make_data_file(obj);
            testCase.verifyError(f,'MATLAB:minrhs')
        end
        
        function testNoFileName(testCase)
            obj = BertiniLab('variable_group',polysym('x'));
            f = @() make_data_file(obj,polysym(0));
            testCase.verifyError(f,'MATLAB:minrhs')
        end
        
        function testMinimalStart(testCase)
            obj = BertiniLab('variable_group',polysym('x'));
            
            for ii = 1:length(testCase.data)
                for jj=1:length(testCase.data_file_names)
                    s = obj.make_data_file(testCase.data{ii},testCase.data_file_names{jj});
                    testCase.verifyEqual(s,testCase.data_file_names{jj})
                    
                    fid = fopen(testCase.data_file_names{jj});
                    n = fscanf(fid,'%d\n\n',1);
                    testCase.verifyEqual(n,1)
                    x = fscanf(fid,'%d');
                    testCase.verifyEqual(x,zeros(2,1))
                    fclose(fid);
                end
            end
        end
        
        function testMultiplePoints(testCase)
            polysyms('x','y')
            obj = BertiniLab('variable_group',[x y]);
            dataxy = polysym(eye(2));
            
            for ii=1:length(testCase.data_file_names)
                s = obj.make_data_file(dataxy,testCase.data_file_names{ii});
                testCase.verifyEqual(s,testCase.data_file_names{ii})
                
                % Read member_points file
                fid = fopen(testCase.data_file_names{ii},'r');
                n = fscanf(fid,'%d\n\n',1);
                p1 = fscanf(fid,'%d %d\n',[2 2]).';
                p2 = fscanf(fid,'%d %d\n',[2 2]).';
                fclose(fid);
                
                testCase.verifyEqual(n,2)
                testCase.verifyEqual(p1,[1 0; 0 0])
                testCase.verifyEqual(p2,[0 0; 1 0])
            end
        end
    end
    
    methods(TestMethodTeardown)
        function teardown(testCase)
            % Delete the input file, if it exists
            warning('off','MATLAB:DELETE:FileNotFound')
            delete(testCase.data_file_names{:});
            warning('on','MATLAB:DELETE:FileNotFound')
        end
    end
end
