classdef test_io_folder < matlab.unittest.TestCase
    % Test the I/O folder setting
    
    properties
        absolute_name
        relative_name
        p_absolute
        p_relative
    end
    methods(TestMethodSetup)
        function createNames(testCase)
            aname = tempname;
            rname = 'Yoopers';
            
            % Delete the I/O folder, if it exists
            warning('off','MATLAB:RMDIR:RemovedFromPat')
            status = rmdir(aname); %#ok<NASGU>
            status = rmdir(rname); %#ok<NASGU>
            warning('on','MATLAB:RMDIR:RemovedFromPat')
            
            testCase.absolute_name = aname;
            testCase.relative_name = rname;
            testCase.p_absolute = BertiniLab('Bertini_io_folder',aname);
            testCase.p_relative = BertiniLab('Bertini_io_folder',rname);
        end
    end
    
    methods(Test)
        
        %======= Absolute path ================
        function testSetAbsolute(testCase)
            % When Bertini_io_folder is changed, the folder should be created.
            fname = testCase.p_absolute.io_folder;
            testCase.verifyTrue(exist(fname,'dir')==7)
        end
        
        function testMakeInputAbsolute(testCase)
            % Just test to see that the file is where it should be.
            p = testCase.p_absolute;
            p.function_def = polysym({'x'});
            p.variable_group = polysym('x');
            make_input_file(p);
            testCase.verifyTrue(exist(fullfile(testCase.absolute_name,'input'),'file')==2)
        end
        
        %======= Relative path ================
        function testSetRelative(testCase)
            % When Bertini_io_folder is changed, the folder should be created.
            fname = testCase.p_absolute.io_folder;
            testCase.verifyTrue(exist(fname,'dir')==7)
        end
        
        function testMakeInputRelative(testCase)
            % Just test to see that the file is where it should be.
            p = testCase.p_relative;
            p.function_def = polysym({'x'});
            p.variable_group = polysym('x');
            make_input_file(p);
            testCase.verifyTrue(exist(fullfile(testCase.relative_name,'input'),'file')==2)
        end
    end
    
    methods(TestMethodTeardown)
        function removeFolders(testCase)
            warning('off','MATLAB:RMDIR:RemovedFromPat')
            status = rmdir(testCase.absolute_name,'s'); %#ok<NASGU>
            status = rmdir(testCase.relative_name,'s'); %#ok<NASGU>
            warning('on','MATLAB:RMDIR:RemovedFromPat')
        end
    end
end