classdef test_Bertini_version < matlab.unittest.TestCase
    %Test the static method bertiniVersion
    
    properties
        emptyString = ''
    end
    methods(TestMethodSetup)
        function setEnvironment(testCase)
            setenv('BL_CALLED',testCase.emptyString)
        end
    end
    methods(Test)
        function testEmptyName(testCase)
            f = @() BertiniLab.bertiniVersion('');
            testCase.verifyError(f,'BertiniLab:bertiniVersion:notFound')
        end
        
        function testFirstTime(testCase)
            % I can't predict where Bertini might be, so I'll use python
            % for this test.
            T = evalc('BertiniLab.bertiniVersion(''python'')');
            testCase.verifyNotEmpty(T)
        end
        function testNotFirstTime(testCase)
            setenv('BL_CALLED','true')
            T = evalc('BertiniLab.bertiniVersion(''python'')');
            testCase.verifyEmpty(T)
        end            
    end
    methods(TestMethodTeardown)
        function teardown(testCase)
            setenv('BL_CALLED',testCase.emptyString)
        end
    end
end