function [sols,varargout] = polysolve(eqns,varargin)
%POLYSOLVE Shortcut for solving polynomial system
%
% sols = polysolve(eqns) solves the system of equations EQNS for the
% variables VARS and returns the finite solutions as POLYSTR arrays in SOLS.
%
% sols = polysolve(eqns,varargin) accepts name/value pairs and sends them
% to BertiniLab.
%
% [sols,poly_system] also returns a BertiniLab object POLY_SYSTEM.
%
% Example:
%   sols = polysolve({'x^2-1'; 'y^2-1'});
%
% See also: findRealRoots, BertiniLab
%
% Note: POLYSOLVE runs BertiniLab under default settings. The equations must have
% numeric coefficients.

% Automatically identify the variables.
polyFun = polysym(eqns);
vars = symvar(polyFun);

% Solve.
poly_system = BertiniLab('function_def',polyFun,'variable_group',vars,varargin{:});
poly_system = solve(poly_system);
sols = poly_system.match_solutions('finite_solutions');

% Warn user if there is a problem.
if poly_system.has_failed_paths || poly_system.has_path_crossings
    results = poly_system.solve_summary;
    istart = strfind(results,'Paths Tracked');
    warning(results(istart:end));
end

% Return BertiniLab object, if desired.
if nargout > 1
    varargout{1} = poly_system;
end
