classdef solveWithConstraints < BertiniLab
    %SOLVEWITHCONSTRAINTS Solve a system with constraints
    
    methods
        function polySystem = solveWithConstraints(gradFcn,N,constrFcn,varargin)
                        
            % Create a symbolic state vector. Its components will be the
            % values to solve for.
            stateVector = polysym('x',[N 1]);
            varGroup = stateVector;
            
            % Construct gradient vector
            g = gradFcn(stateVector);
            if nargin > 2 && ~isempty(constrFcn)
                [c,gradc] = constrFcn(stateVector);
                
                lambda = polysym('lambda',size(c));
                varGroup = {varGroup,lambda}; % Use multihomogenous homotopy
                
                lambda = repmat(lambda,1,numel(g)/numel(lambda)).';
                
                g = [g + lambda.*gradc; c];
            end
            
            % Define the polynomial system
            polySystem = polySystem@BertiniLab('variable_group',varGroup, ...
                'function_def',g,varargin{:});
        end
    end
   
end

