function sols = findRealRoots(polyFun)
%FINDREALROOTS Find the real roots of a polynomial system

polyFun = polysym(polyFun);
vars = symvar(polyFun);
% Solve and retrieve real finite solutions.
poly_system = BertiniLab('function_def',polyFun, ...
    'variable_group',vars);
poly_system = solve(poly_system);
sols = poly_system.match_solutions('real_finite_solutions');
% Convert solutions to double precision and remove
% negligible imaginary part.
sols = structfun(@double,sols,'UniformOutput',false);
sols = structfun(@real,sols,'UniformOutput',false);
end