%% Performing a Newton iteration
% Section 7.3.2 from _Numerically solving polynomial systems with Bertini_,
% by Daniel J. Bates, Jonathan D. Haunstein, Andrew J. Sommese and Charles
% W. Wampler (SIAM 2013).
%
% Normally, Bertini executes Newton's method only near nonsingular
% solutions, but it allows users to perform a single Newton iteration on
% any set of points. In BertiniLab this is implemented with the method
% |Newton_iteration|.
%
% This example uses the circle-parabola system again. Again, a start file
% is needed. Starting points must be provided in a matrix with one column
% per point.

load circle_parabola_intersection
circle_parabola_intersection.config  = struct('MPType',1,'Precision',64);
points.x = [.75 1e-15];
points.y = [2 .25];
[newPoints,successFlag,NewtonResidual,conditionNumber] = ...
    circle_parabola_intersection.Newton_iteration(points);

%%
% The new points (x,y pairs) are
disp([newPoints.x newPoints.y])

%%
% The output |successFlag| is a logical variable. Bertini returns a 0 for
% success and a -1 for failure, but in BertiniLab we use the MATLAB
% conventions of true (1) and false (0).
disp(successFlag)

%%
% The second solution was unsuccessful. The condition numbers are
disp(conditionNumber)

%%
% Bertini assigns a condition number of -1 to the unsuccessful result. The
% Newton residuals are
disp(NewtonResidual)


%%
% The large Newton residual for the second solution indicates that a large
% step must be taken, which is why it does not work at this precision. We
% redo this example with a higher precision:
circle_parabola_intersection.config.Precision  = 128;
[newPoints,successFlag,NewtonResidual,conditionNumber] = ...
    circle_parabola_intersection.Newton_iteration(points);

%%
% And now it works:
disp(successFlag)


