%% Paths to infinity
% Section 4.2 from _Numerically solving polynomial systems
% with Bertini_, by Daniel J. Bates, Jonathan D. Haunstein, Andrew J.
% Sommese and Charles W. Wampler (SIAM 2013).
%
% Find the intersection of two circles of the form
%
% $$ (x-a)^2 + (y-b)^2 - r^2 = 0. $$
%
% Generally they intersect at two points, but the system of polynomials has
% four solutions.

config = struct('SecurityLevel',1);
polysyms x y

poly_system = BertiniLab('function_def',[x^2+y^2-1; (x-1)^2+(y-1)^2-1], ...
    'variable_group',[x y],'config',config);
poly_system = poly_system.solve;
sols = poly_system.match_solutions('raw_solutions');
xsols = double(sols.x);
ysols = double(sols.y);

fprintf('%17s %32s\n','x','y')
ifinite = abs(imag(xsols))<1e-11;
fprintf('%15.11f + %15.11fi %15.11f + %15.11fi\n', ...
    [real(xsols(ifinite)) imag(xsols(ifinite)) real(ysols(ifinite)) imag(ysols(ifinite))].')

%%
% The remaining two are solutions at infinity - asymptotically approaching
% the lines $x=\pm y i$ as the homotopy parameter $t$ goes to zero.
fprintf('%19s %39s\n','x','y')
fprintf('%13.11e + %13.11ei %13.11e + %13.11ei\n', ...
    [real(xsols(~ifinite)) imag(xsols(~ifinite)) real(ysols(~ifinite)) imag(ysols(~ifinite))].')

