%% Multihomogeneous homotopy
% Example 5.3 from _Numerically solving polynomial systems
% with Bertini_, by Daniel J. Bates, Jonathan D. Haunstein, Andrew J.
% Sommese and Charles W. Wampler (SIAM 2013).
%
% In this example, the structure of the system is such that, by putting |x|
% and |y| in different variable groups, we can reduce the number of paths
% to track from 4 to 2. This is done by wrapping |x| and |y| in a cell
% array when constructing BertiniLab.

%%
% The simple homogeneous homotopy. To avoid truncated infinite paths, we
% need to set the security level to 1.
polysyms x y
poly_system = BertiniLab('variable_group',[x,y],'function_def',[x*y-1; x^2-1], ...
    'config',struct('SecurityLevel',1));
poly_system = solve(poly_system);

results = poly_system.solve_summary;
istart = strfind(results,'Finite Solution Summary');
disp(results(istart:end))

%%
% We can change to a 2-homogeneous homotopy by putting curly brackets
% around |x,y|. Now we do not need to set the security level.
polysyms x y
poly_system = BertiniLab('variable_group',{x,y},'function_def',[x*y-1; x^2-1]);
poly_system = solve(poly_system);

results = poly_system.solve_summary;
istart = strfind(results,'Finite Solution Summary');
disp(results(istart:end))
