%% Intersections of straight lines
% Example 1.1 from _Numerically solving polynomial systems
% with Bertini_, by Daniel J. Bates, Jonathan D. Haunstein, Andrew J.
% Sommese and Charles W. Wampler (SIAM 2013).
%
% Find the zeros of the function
%
% $$f(x,y) = \left( x^2-1, y^2-4 \right), $$
%
% which are four isolated solutions (the intersections of two pairs of
% parallel lines).
%
% To formulate the polynomial system, we use cell arrays of strings. In the
% function definition, you must be careful to use a semicolon between
% equations so the result is a column vector. If there is more than one
% column, BertiniLab expects the first column to be the equation names.

poly_system = BertiniLab('function_def',{'x^2-1'; 'y^2-4'},'variable_group',{'x','y'});
poly_system = solve(poly_system);

%%
% The summary of this run, which by default Bertini sends to the screen, is
% captured in |poly_system.solve_summary|:
disp(poly_system.solve_summary)

%%
% All the solutions are stored in |raw_solutions|, but since they are real
% they are also stored in |real_finite_solutions|:
sols = poly_system.match_solutions('real_finite_solutions');
disp('x, y =')
disp([real(double(sols.x)) real(double(sols.y))])