%% Intersection of two spheres and a cone using regeneration
% Section 5.4 from _Numerically solving polynomial systems
% with Bertini_, by Daniel J. Bates, Jonathan D. Haunstein, Andrew J.
% Sommese and Charles W. Wampler (SIAM 2013).
% 
% Use regeneration to find the intersections of two spheres and a cone.

config = struct('UseRegeneration',1);
polysyms x y z
cx = polysym('cx',[3 1]);
cy = polysym('cy',[3 1]);
cz = polysym('cz',[3 1]);
r = polysym('r',[3 1]);

spheres = (x-cx(1:2)).^2 + (y-cy(1:2)).^2 + (z-cz(1:2)).^2 - r(1:2).^2;
cone = (x-z*cx(3))^2 + (y-z*cy(3))^2 - (z*r(3))^2;

poly_system = BertiniLab('function_def',[spheres; cone],'variable_group',[x y z], ...
    'config',config,'random',[cx; cy; cz; r]);
poly_system = poly_system.solve;

%%
% We will print the regeneration summary:
s = poly_system.solve_summary;
istart = strfind(s,'*************** Regeneration summary');
iend = strfind(s,'Non-singular Finite Solution Summary');
disp(s(istart:iend-1))
