%% Intersection of circle with |y| axis
% Example 1.9 from _Numerically solving polynomial systems
% with Bertini_, by Daniel J. Bates, Jonathan D. Haunstein, Andrew J.
% Sommese and Charles W. Wampler (SIAM 2013).
%
% Find the zeros of 
%
% $$f(x,y) = \left((x-c)^2+y^2-1,x\right)$$
%
% for $c=1$ (which produces a singular solution). The constant $c$ can be
% modified to move the circle left or right.

poly_system = BertiniLab('function_def',{'(x-c)^2+y^2-1';'x'},'variable_group',{'x','y'}, ...
    'constant',{'c',1});
poly_system = poly_system.solve;

%%
% The summary for this run is:
disp(poly_system.solve_summary)

%%
% The solutions are singular, being nearly identical and having large
% condition numbers. The final tolerance by default is $10^{-11}$;
% displayed to that accuracy, the roots are identical:
sols = poly_system.match_solutions('singular_solutions');
solution_info = poly_system.read_raw_data;
condnum = [solution_info.condition_number];
xsols = double(sols.x(:)); ysols = double(sols.y(:));
fprintf('%17s %35s %32s\n','x','y','condition number')
fprintf('%15.11f + %15.11fi  %15.11f + %15.11fi %15.2g\n', ...
    [real(xsols) imag(xsols) real(ysols) imag(ysols) condnum(:)].')
