%% Incomplete intersection
% Example 9.2 from _Numerically solving polynomial systems with Bertini_,
% by Daniel J. Bates, Jonathan D. Haunstein, Andrew J. Sommese and Charles W. Wampler (SIAM
% 2013).
%
% The square system
%
% $$ y-x^2 = 0 $$
%
% $$ x y - z = 0 $$
%
% $$ x z - y^2 = 0 $$
%
% has as its intersection the twisted cubic curve instead of isolated points.

polysyms x y z
f = y-x^2;
g = x*y-z;
h = x*z-y^2;
poly_system = BertiniLab('variable_group',[x y z],'function_def',[f; g; h]);
poly_system = poly_system.irreducible_decomposition;
results = poly_system.solve_summary;
istart = strfind(results,'************** Decomposition');
disp(results(istart:end))
