%% Generalized eigenvalue problem
% Example 4.2 from _Numerically solving polynomial systems
% with Bertini_, by Daniel J. Bates, Jonathan D. Haunstein, Andrew J.
% Sommese and Charles W. Wampler (SIAM 2013).
%
% Solve the generalized eigenvalue problem
%
% $$\mu A v = \lambda B v. $$
%
% A singular problem is chosen in which the solutions are $(\mu,\lambda) =
% (0,1)$ and $(\mu,\lambda) =(0,1)$, so the problem cannot be reduced to
% having a single eigenvalue. This problem is homogeneous in two separate
% sets of coordinates. Note that, in the definition of |poly_system| two
% groups of variables are assigned to |hom_variable_group|: |(mu, lambda)|
% and |v|.

polysyms mu0 lambda; % Use 'mu0' because 'mu' is a Matlab toolbox command
v = polysym('v',[1 2]);
fname = polysym('f',[1 2]);
A = [1 2; 2 4]; B = [4 -2; -2 1];
fval = mu0*A*v.' - lambda*B*v.';

poly_system = BertiniLab('function_def',fname(:),'function_def',fval(:), ...
    'hom_variable_group',{[mu0 lambda],v});
poly_system = solve(poly_system);
sols = poly_system.match_solutions('raw_solutions',mu0,lambda,v);

%%
% This problem has eigenvalue pairs |mu0| and |lambda|:
musols = double(sols.mu0); lambdasols = double(sols.lambda);
fprintf('%14s %16s\n','mu','lambda')
fprintf('%15.4f %15.4f\n',[real(musols) real(lambdasols)].')

