%% Complete intersection
% Example 9.1 from _Numerically solving polynomial systems with Bertini_,
% by Daniel J. Bates, Jonathan D. Haunstein, Andrew J. Sommese and Charles
% W. Wampler (SIAM 2013).
%
% The system
%
% $$ x^2+y^2+z^2-1 = 0$$
%
% $$ x y = 0 $$
%
% $$ y-z = 0 $$
%
% is the intersection of the unit sphere with the yz and xz planes and also
% the y=z plane, yielding four points. This is an example of a complete
% intersection.

polysyms x y z
f = x^2+y^2+z^2-1;
g = x*y;
h = y-z;
poly_system = BertiniLab('variable_group',[x y z],'function_def',[f; g; h]);
poly_system = poly_system.irreducible_decomposition;
results = poly_system.solve_summary;
istart = strfind(results,'************** Decomposition');
disp(results(istart:end))
