function publishDocs(docName)
%PUBLISHDOCS Publish documentation in MATLAB style

if nargin < 1
    docName = {'GettingStartedWithBertiniLab.m', 'User_Guide.m', ...
        'BertiniLab_User_Guide.m', 'Polysym_User_Guide.m', 'First_run.m', ...
        'helpfuncbycat.m', 'Installing_BertiniLab.m', 'SystemRequirements.m', ...
        'WhatIsBertini.m', 'WhatIsBertiniLab.m', 'ReleaseNotes.m', 'KnownIssues.m', ...
        'mytoolbox_product_page.m'};
elseif ischar(docName)
    docName = {docName};
end

docFolder = fullfile(BertiniLabRoot,'doc');
htmlFolder = fullfile(docFolder,'html');
options_doc_BertiniLab.stylesheet = fullfile(docFolder,'mxdom2mathjax.xsl');

% Most of the documentation goes in the doc/html folder
for ii=1:length(docName)
    publish(docName{ii},options_doc_BertiniLab);
end

% Copy the Getting Started page to BertiniLab root.
copyfile(fullfile(htmlFolder,'GettingStartedWithBertiniLab.html'), ...
    fullfile(BertiniLabRoot,'GettingStartedWithBertiniLab.html'))

% Update search database
builddocsearchdb(htmlFolder)

% Remove files created by Bertini
BertiniClean