classdef generalized_eigenvalue_problem < BertiniLab
    % Solve a generalized eigenvalue problem
    %
    % The variables of interest are kappa and lambda, so the solve method is
    % modified to extract their values from the solutions.
    
    properties
        kappa = [];
        lambda = [];
    end
    methods
        function obj = generalized_eigenvalue_problem(A,B)
            m = polysym('kappa');
            l = polysym('lambda');
            N = length(A);
            v = polysym('v',[1 N]);
            
            obj = obj@BertiniLab('function_def',(m*A-l*B)*v.','hom_variable_group',{[m l],v});
            obj.kappa = m;
            obj.lambda = l;
        end
        function obj = solve(obj)
            obj = solve@BertiniLab(obj);
            sstruct = obj.match_solutions('nonsingular_solutions',obj.kappa,obj.lambda);
            
            obj.kappa = sstruct.kappa;
            obj.lambda = sstruct.lambda;
        end
    end
end