%% Installing BertiniLab
%
% To install BertiniLab, go to the folder |BertiniLab| and type the command
%
%   install
% 
% This adds the BertiniLab folders to the MATLAB <matlab:doc('path') path>
% and creates two utilities, |BertiniLabRoot| and |BertiniLabVersion|. It
% also returns a string that can be added to the |startup.m| file so this
% folder is automatically added to the path when MATLAB is started. Once
% this is done, it is not necessary to install BertiniLab again.
%
% Source code and executables for Bertini can be obtained from the
% <https://bertini.nd.edu/ Bertini home page>. To use Bertini on a Mac,
% simply download the executable. On a PC, it must be compiled on Cygwin
% (see the installation instructions that come with the package). Then
% locate the following dynamic libraries and copy them to the folder that
% the Bertini executable resides in:
%
% * cygwin1.dll
% * cygcc*.dll
% * cyggmp*.dll
% * cygmpfr*.dll
%
% (the stars represent characters that will depend on the version of cygwin
% installed).
%
% BertiniLab needs to be told where Bertini is by doing the following:
% 
% # Open |@BertiniLab/BertiniLab.m|.
% # Edit the line |program_folder = '/usr/local/bin';| to provide the
%   folder where |bertini| resides.
% # Edit the line |program_name = 'bertini';| to provide the name that is
%   used to call Bertini.
%
% When you install Bertini in Cygwin, you provide a Unix address for the
% installation, for example, |/usr/local/bin/bertini|. This must be
% converted to its Windows address by changing the forward slashes to
% backward slashes and appending it to the name of the Cygwin folder, for
% example, |C:\cygwin64\usr\local\bin\bertini|.
%
% BertiniLab was tested on Matlab R2012b and later on Mac, Windows and
% Linux. A suite of unit tests are included in the folder |tests|. For
% 2013a and later, the tests use the MATLAB Unit Test Framework. The
% command |runAllTests|, at the base of the |tests| folder, runs all the
% tests. The user can also visit a particular test folder and type
% |runtests(pwd)| to run all the tests in that folder. For more information
% on the framework type |docsearch "Unit Testing Framework"|.
%
% For earlier versions, there is a suite of tests in the subfolder |R2012 and earlier|.
% These require the MATLAB xUnit Test Framework by Steve Eddings. This
% package can be downloaded from MATLAB Central:
%
% <html>
% <a href="https://www.mathworks.com/matlabcentral/fileexchange/22846-matlab-xunit-test-framework">MATLAB xUnit Test Framework</a>
% </html>

