function varlist = symvar(p)
%SYMVAR Determine symbolic variables in expression
%
% varlist = symvar(p) inputs a polysym array P and returns a polsym array
% of variables.
%
% Variable names must begin with a letter and can be followed by any
% combination of letters, digits, underscores and hard brackets. The
% exceptions are:
%
% *I (square root of -1)
% *Pi, e (reserved for the transcendental numbers)
% *Special functions: exp, sin and cos.

% Array: summing p allows it to be treated as a scalar.
if isempty(p)
    varlist = polysym.empty;
    return
elseif numel(p) > 1
    p = sum(p(:));
end

S = cellstr(p);

% Lookaround operator at beginning makes sure that a letter is not preceded
% by a number (e.g., 1e10).
matchlist = regexp(S{:},'(?<![0-9])[a-zA-Z][\w_\[\]]*','match');
matchlist = unique(matchlist);

exceptions = {'I','Pi','e','exp','sin','cos'};
matchlist = setdiff(matchlist,exceptions);

varlist = polysym(matchlist);