function s = sum(obj,dim)
% Return sum of POLYSYM elements
%
% S = SUM(OBJ) returns a sum of the elements of OBJ if OBJ is a vector.
% If OBJ is a matrix, it returns the sum of the columns, returning a row
% vector.
%
% S = SUM(OBJ,DIM) returns the sum of elements along dimension DIM.
%
% Example:
%  s = polysym({'a','b'; 'c','d'});
%  sum(s)
%   'a+c'    'b+d'
%
% See also PLUS, MTIMES.

if isempty(obj)
    s = obj;
    return
end

if nargin < 2
    dim = 1;
    if isrow(obj)
        dim = 2;
    end
end
validateattributes(dim,{'numeric'},{'integer','scalar','>',0,'<',3}, ...
    'polysym:diff','dim',2)

switch dim
    case 1
        s = obj(1,:);
        for k=2:size(obj,1)
            s = s+obj(k,:);
        end
    case 2
        s = obj(:,1);
        for k=2:size(obj,2)
            s = s+obj(:,k);
        end
end
