function [p,varargout] = sort(p)
%SORT Sort array elements in ascending or descending order
%
% B = sort(A) sorts, in ascending order, the elements of A (if A is a
% vector) or each column of A (if A is a matrix).
%
% The elements of A are sorted in numerical and lexicographical order; the
% order is the same as would be obtained using B = sort(cellstr(A)).
%
% [B,IX] = sort(A,...) also returns an array of indices IX, where
% size(IX)==size(A). If A is a vector, B = A(IX). If A is an m-by-n
% matrix, then each column of IX is a permutation vector of the
% corresponding column of A, such that
% 
%  for j = 1:n
%     B(:,j) = A(IX(:,j),j); 
%  end
%
% Note: As is true for cell arrays, SORT does not support the DIM and MODE
% arguments.

assert(nargin==1,'polysym:sort:TooManyInputs', ...
    'DIM and MODE arguments not supported for polysym arrays.')

ir = isrow(p);
if ir
    p = p.';
end

c = cellstr(p);

pc = cell(size(p));
ix = zeros(size(p));

for ii=1:size(p,2)
    [pc(:,ii),ix(:,ii)] = sort(c(:,ii));
end

p = polysym(pc);
if ir
    p = p.';
    ix = ix.';
end

if nargout > 1
    varargout{1} = ix;
end