function obj = rdivide(obj1,obj2)
% Overloaded right array division (./) function
%
% OBJ=OBJ1./OBJ2  inputs two arrays of POLYSYM objects and returns
% another in which OBJ(i) now represents OBJ1(i)/OBJ2(i). If either OBJ1 or
% OBJ2 is a scalar, it is expanded to an array of the same dimensions as
% the other input.
%
% Example:
%  s = polysym({'s'});
%  t = polysym({'t'});
%  disp(s./t)
%
% See also LDIVIDE.

obj1 = polysym(obj1); obj2 = polysym(obj2);
[obj1,obj2] = makeSameSize(obj1,obj2);

% Do division operation
obj = obj1;
for k=1:numel(obj1)
    if iszero(obj2(k))
        error('polysym:rdivide:DivideByZero', ...
            'Division by zero attempted.')
    elseif ~iszero(obj1(k)) && ~isone(obj2(k))
        s1 = checkParens(obj1(k));
        s2 = checkParens(obj2(k));
        obj(k).Value = [s1,'/',s2];
    end
end
end% rdivide
