function array_collection = put_in_arrays(p)
%PUT_IN_ARRAYS Collect components into arrays, where appropriate.
%
% array_collection = put_in_arrays(p) looks for elements of P with a common
% character string for a base and indexing. If they form a complete array,
% it is returned as part of ARRAY_COLLECTION. Any other elements are
% returned as separate terms.

% Find unique character strings in variable names
matches = p.char_base;
ivar = find(cellfun(@(x) ~isempty(x),matches));
matches = matches(ivar);
var_root = unique(matches);

% Assemble polysym arrays in a cell array
array_collection = {};
for ii=1:length(var_root)
    idx = strcmp(var_root{ii},matches);
    pcell = assemble_components(p(ivar(idx)));
    array_collection = [array_collection; pcell(:)]; %#ok<AGROW>
end
