function c = format_list(obj,delimiter)
% FORMAT_LIST Format terms in POLYSYM array in comma-delimited string.
%
% c = p.format_list(obj,delimiter) inputs DELIMITER, a string. Returns C, a
% string containing the elements of P separated by DELIMITER. The default
% for DELIMITER is a comma.
%
% Example:
%   x = polysym({'x','y'});
%   format_list(x)
% 
%   ans =
% 
%   x, y
%
% See also: format_equations

% Create cell array of strings
s = cellstr(obj);

% Format list
c = sprintf(['%s',delimiter,' '],s);
c = c(1:end-1);
