function tf = ne(p1,p2)
%NE Test for ineuality of POLYSYM arrays
%   
%   p1 ~= p2 determines which elements of a POLYSYM array P1 are uneual to
%   those in another array P2. P2 can be a numeric, cell, SYM or POLYSYM
%   array.
%
%   The two arrays must have the same dimensions, unless P2 is a scalar.
%   The result is a logical array the same size as P1 with values true (1)
%   or false (0).
%
%   Examples:
%       polysym(eye(2)) ~= ones(2)
%       polysym(eye(2)) ~= 1
%       polysym(eye(2)) ~= {'1', '0'; '0', '1'}
%
%   See also: eq

tf = ~eq(p1,p2);
