function obj = mrdivide(obj1,obj2)
% Overloaded right-matrix division (/), restricted to scalar divisor
%
% OBJ=PLUS(OBJ1,OBJ2) inputs OBJ1, an array of POLYSYM objects, and OBJ2, a
% scalar POLYSYM object, string or number. Returns OBJ, a POLYSYM object in
% which OBJ(i) now represents OBJ1(i)/OBJ2.
%
% If one of the inputs are empty, returns the other object.
%
% Example:
%  s = polysym({'s'});
%  t = polysym({'t'});
%  disp(s/t)
%
% See also RDIVIDE.

assert(numel(obj2)<= 1,'polysym:mrdivide:NotScalar',...
        'Right division (/) must have scalar divisor.')

obj1 = polysym(obj1); obj2 = polysym(obj2);

% Do division operation
obj = obj1;
for k=1:numel(obj1)
    if iszero(obj2)
        error('polysym:mrdivide:DivideByZero', ...
            'Division by zero attempted.')
    elseif ~iszero(obj1(k)) && ~isone(obj2)
        s1 = checkParens(obj1(k));
        s2 = checkParens(obj2);
        obj(k).Value = [s1,'/',s2];
    end
end
end% mrdivide
