function obj = mpower(obj1,n)
% Overloaded array power (^) function restricted to scalar integer power
%
% OBJ = POWER(OBJ1,N)  inputs OBJ1, a square array of POLYSYM objects, and
% N, an integer. Returns OBJ, a POLYSYM object representing OBJ1^N.
%
% Example:
%
% See also ISZERO, ISONE.

validateattributes(n,{'numeric'},{'integer','scalar'},'mpower','n',2)

msg = sprintf('%s\n%s','Inputs must be a scalar and a square matrix.',...
    'To compute elementwise POWER, use POWER (.^) instead.');
assert(size(obj1,1) == size(obj1,2),'polysym:mpower:notScalarAndSquareMatrix',msg)

obj = polysym(eye(length(obj1)));
if numel(obj1)==1
    switch n
        case 0
            obj=polysym('1');
        case 1
            obj=obj1;
        otherwise
            if iszero(obj1)
                obj=polysym('0');
            elseif isone(obj1)
                obj=obj1;
            else
                s = checkParens(obj1);
                obj.Value = [s,'^',num2str(n)];
            end
    end
    
else
    for k=1:n
        obj = obj*obj1;
    end
end
