function obj = mldivide(obj1,obj2)
% Overloaded left-matrix division (\), restricted to scalar divisor
%
% OBJ=PLUS(OBJ1,OBJ2) inputs and OBJ2, a scalar POLYSYM object, string or
% number, and OBJ1, an array of POLYSYM objects. Returns OBJ, a POLSTRY
% object in which OBJ(i) now represents OBJ2(i)/OBJ1.
%
% If one of the inputs are empty, returns the other object.
%
% Example:
%  s = polysym({'s'});
%  t = polysym({'t'});
%  disp(s\t)
%
% See also RDIVIDE.

assert(numel(obj1) <= 1,'polysym:mldivide:NotScalar',...
        'Left division (/) must have scalar divisor.')

obj1 = polysym(obj1); obj2 = polysym(obj2);

% Do division operation
obj = obj2;
for k=1:numel(obj2)
    if iszero(obj1)
        error('polysym:mldivide:DivideByZero', ...
            'Division by zero attempted.')
    elseif ~iszero(obj2(k)) && ~isone(obj1)
        s1 = checkParens(obj2(k));
        s2 = checkParens(obj1);
        obj(k).Value = [s1,'/',s2];
    end
end
end% mldivide
