function obj = minus(obj1,obj2)
% Overloaded minus (-) function
%
% OBJ=PLUS(obj1,obj2) inputs two arrays of POLYSYM objects and returns
% another in which OBJ(i) now represents OBJ1(i) - OBJ2(i). If either of
% OBJ1 or OBJ2 are scalar, it is expanded to the dimensions of the other
% object. If one of the inputs are empty, returns the other object.
%
% Example:
%  s = polysym({'s'});
%  t = polysym({'t'});
%  disp(s-t)
%
% See also PLUS.

obj1 = polysym(obj1); obj2 = polysym(obj2);
[obj1,obj2] = makeSameSize(obj1,obj2);

obj = obj1;
for k=1:numel(obj1)
    if iszero(obj1(k))
        obj(k) = -obj2(k);
    elseif ~iszero(obj2(k))
        obj(k).Value = [obj1(k).Value,'-',checkParens(obj2(k))];
    end
end
