function tf = iszero(obj)
% Determines which members of a POLYSYM object represent the
% number 0.
%
% TF = ISZERO(OBJ) inputs an array of POLYSYM objects and returns an array
% of the same dimensions. Each component has the logical value TRUE where
% the object represents 0 and FALSE otherwise. For a POLYSYM object P to
% represent 0, P.Value must be equivalent to '0'. Leading or trailing white
% space characters and (balanced) parentheses are allowed.
%
% Note: Expressions are evaluated to double precision.
%
% Example:
%   obj = polysym('  0');
%   iszero(obj)
% 
%   ans =
% 
%        1
%
% See also ISONE.

tf = false(size(obj));

for k=1:numel(obj)
    startindex = regexpi(strtrim(obj(k).Value),'^0(\.0*)?(e[0-9]*)?$');
    if ~isempty(startindex)
%         if str2num(obj(k).Value)==0 %#ok<ST2NM>
        tf(k) = true;
    end
end
