function tf = isone(obj)
% Determines which members of a POLYSYM object represent the
% number 1.
%
% TF = ISONE(OBJ) inputs an array of POLYSYM objects and returns an array
% of the same dimensions. Each component has the logical value TRUE where
% the object represents 1 and FALSE where it doesn't. Expressions like '1',
% '1.00' and '1e0' are matched. Leading or trailing white space characters
% are allowed.
%
% Note: Expressions are evaluated to double precision.
%
% Example:
%   obj = polysym('1');
%   isone(obj)
% 
%   ans =
% 
%        1
%
% See also ISZERO.

tf = false(size(obj));

for k=1:numel(obj)
    startindex = regexpi(strtrim(obj(k).Value),'^1(\.0*)?(e0)?$');
    if ~isempty(startindex)
%     if str2num(obj(k).Value)==1 %#ok<ST2NM>
        tf(k) = true;
    end
end

