function eqns = format_equations(LHS,RHS)
% FORMAT_EQUATIONS Create cell array of strings representing equations
%
% eqns = format_equations(LHS,RHS) inputs LHS and RHS and returns a cell
% array of strings representing LHS=RHS. Either input can be a POLYSYM
% array, a cell array of names, or a string. If it is a string, say 'f', it is
% expanded to an array of subscripted strings, {'f1','f2', ...}. EQNS is a
% cell array of strings with each string containing one equation.
%
% EXAMPLE:
%   polysyms x y
%   RHS(1) = x^3*29/16 - 2*x*y;
%   RHS(2) = y - x^2;
%   polysym.format_equations('f',RHS)
% 
%   ans = 
% 
%       'f1=x^3*29/16-2*x*y'    'f2=y-x^2'
%
% See also: format_list

% Assemble equations
% sz = max([size(RHS); size(LHS)]); 
% if prod(sz)>1
%     LHS = polysym(LHS,sz);
%     RHS = polysym(RHS,sz);
% else
%     LHS = polysym(LHS);
%     RHS = polysym(RHS);
% end

LHS = cellstr(LHS);
RHS = cellstr(RHS);
if isempty(LHS) && isempty(RHS)
    eqns = {};
else
    eqns = strcat(cellstr(LHS),'=',cellstr(RHS));
end
