function str = format_array(p,varargin)
%FORMAT_ARRAY Represent polysym array as formatted char array
%
% str = p.format_array formats P left-justified with spaces between terms.
%
% str = p.format_array(delimiter) inserts the string DELIMITER between
% terms. Default is a single blank.
%
% str = p.format_array(...,just) specifies the justification ('left',
% 'right' or 'center'). Default is 'left'.

if nargin >= 2 && ~isempty(varargin{1})
    delimiter = varargin{1};
else
    delimiter = ' ';
end

if nargin >= 3
    just = varargin{2};
else
    just = 'left';
end

c = cellstr(p);
nrows = size(c,1); ncols = size(c,2);
delimiter = repmat(delimiter,nrows,1);

str = '';
if ncols > 0
    for ii=1:ncols-1
        str = [str strjust(char(c(:,ii)),just) delimiter];
    end
    str = [str strjust(char(c(:,ncols)),just)]; % leave off delimiter
end