function obj = exp(obj)
% Overloaded exponential function
%
% obj = exp(obj) inputs an array of POLYSYM objects and returns their
% exponentials.
%
% Generally these are just strings, e.g., 'exp(x)'. However, the exponential
% of a zero is returned as 1.
%
% Example:
%   polysyms x
%   exp(x)
%
% See also SIN, COS.

for k=1:numel(obj)
    if iszero(obj(k))
        obj(k).Value = '1';
    else
        obj(k).Value = ['exp(',obj(k).Value,')'];
    end
end