function x = double(p)
%DOUBLE Convert polysym array to double precision
%
% x = double(p) inputs a polysym array consisting of numbers and returns an
% array X of double precision numbers. Returns an error if any of the
% polysym objects are not valid representations of a number.
%
% See also: write_number

S = lower(cellstr(p)); %converts Pi to pi and I to i
x = cellfun(@str2num,S,'UniformOutput',false);
x = cell2mat(x);