function disp(p)
% Overloaded DISP for a POLYSYM object.
%
% DISP(P) displays the object without printing the object name.
%
% Example:
%  s = polysym({'a','b'; 'c','d'});
%  disp(s)
%
% See also cellstr.

str = p.format_array(' ','right');

% Add a blank row between each pair of rows
c = cellstr(repmat(' ',2*size(str,1)-1,1));
c(1:2:end) = cellstr(str);

disp(char(c))
