function pc = cross(p1,p2,dim)
%CROSS Vector cross product
%
% pc = cross(p1,p2) inputs two arrays, at least one composed of POLYSYM
% objects, and returns their product along the first dimension of length 3.
%
% pc = cross(p1,p2,dim) returns the cross product along the dimension DIM.
%
% See also: cross

p1 = polysym(p1); p2 = polysym(p2);

% Check dimensions
assert(isequal(size(p1),size(p2)),'polysym:cross:InputSizeMismatch', ...
       'P1 and P2 must have the same size.')

if nargin < 3
   dim = find(size(p1)==3,1);
   assert(~isempty(dim), 'polysym:cross:InvalidDimAorB', ...
         'P1 and P2 must have at least one dimension of length 3.')
end

% Permute so that DIM becomes the row dimension
perm = [dim:max(length(size(p1)),dim) 1:dim-1];
p1 = permute(p1,perm);
p2 = permute(p2,perm);

% Calculate cross product
pc = [p1(2,:).*p2(3,:)-p1(3,:).*p2(2,:)
     p1(3,:).*p2(1,:)-p1(1,:).*p2(3,:)
     p1(1,:).*p2(2,:)-p1(2,:).*p2(1,:)];
pc = reshape(pc,size(p1));

% Post-process.
pc = ipermute(pc,perm);
