function proot = common_name(p)
%COMMON_NAME Find common part of an array of variable names
%
% proot = common_name(p) finds the common part of the variable names in an
% array and returns it as a string. If there is no common part, the string
% is empty.
%
% Example:
%   p = polysym('x',3); % Returns array with terms like 'x2_3'
%   common_name(p)

pc = p.cellstr;
pfirst = pc{1};

for ii=1:length(pc{1})
    proot = pfirst(1:ii);
    matches = cellfun(@(x) ~isempty(x),strfind(pc,proot));
    
    if ~all(matches(:))
        proot = proot(1:end-1);
        break
    end
end