function proots = char_base(p)
%CHAR_BASE Find character strings in an array of variable names
%
% proot = char_base(p) finds the character strings in variable names and
% returns them as a cell array of strings. For each term with no basis
% (e.g., a number), the whole term is returned.
%
% Example:
%   p = polysym('x',3); % Returns array with terms like 'x2_3'
%   char_base(p)

pstr = cellstr(p);
proots = regexp(pstr,'[a-zA-Z]*','match');

if ~isempty(proots)
    
    for ii=1:numel(proots)
        if isempty(proots{ii})
            proots{ii} = pstr(ii);
        end
    end
    
    proots = [proots{:}];
end
