function s = cellstr(obj)
%CELLSTR Convert array of POLYSYM objects to cell array of strings
%
% S = cellstr(obj) inputs OBJ, an array of POLYSYM objects, and returns
% S, a cell array of strings with the same dimensions as OBJ. Any objects
% that are equivalent to zero are represented by the string '0'.
%
% Example:
%   obj = polysym({'s','t'});
%   disp(cellstr(obj))
%    's'    't'
%
% See also disp cellstr

s = cell(size(obj));
for k=1:numel(s)
    s{k} = obj(k).Value;
end
