function p_out = assemble_components(parray)
%ASSEMBLE_COMPONENTS See if a possible array has all the indices
%
% p_out = assemble_components(parray) inputs an array of polysym objects.
% Checks to see whether they have a root name and a complete set of
% indices. If they do, they are assembled into a single polysym array. If
% not, they are returned as separate components. Either way P_OUT is a cell
% array of polysym objects.

% Check that all the root names are the same, and keep the root name.
rname = unique(parray.char_base);
if numel(rname) == 1
    
    pstr = cellstr(parray);
    index_match = regexp(pstr,'(?<=[a-zA-Z_])[0-9]*','match');
    f = @(c) cellfun(@str2num,c);
    index_match = cellfun(f,index_match,'UniformOutput',false);
    
    % Check the consistency of the number of indices for each variable.
    sz = cellfun(@numel,index_match,'UniformOutput',false);
    sz = unique([sz{:}]);
    
    % Try to form an array
    if numel(sz) == 1  && sz~=0
        idx = cell2mat(index_match(:));
        if ~any(idx(:)==0)
            
            array_dims = max(idx,[],1);
            if numel(array_dims)==1
                array_dims = [array_dims 1];
                idx = [idx ones(size(idx))];
            end
            
            all_indices = zeros(array_dims);
            
            for ii=1:size(idx,1)
                all_indices(idx(ii,1),idx(ii,2))=1;
            end
            
            if all(all_indices(:)==1) && numel(all_indices)>1
                p_out = {polysym(rname{1},array_dims)};
                return
            end
        end
    end
end

% If they don't form an array, return them as individual terms.
p_out = cell(size(parray));
for ii=1:numel(parray)
    p_out{ii} = parray(ii);
end