function print_declarations(fid,declarationType,vars,terminator)
%PRINT_DECLARATIONS Format and print declarations for Bertini or paramotopy
%input
%
% print_declarations(fid,declarationType,vars,terminator) inputs FID, the
% MATLAB file identifier (returned by FOPEN); DECLARATIONTYPE, a string;
% VARS, a POLYSYM array or cell array of POLYSYM objects; and TERMINATOR, a
% string. Prints the declarations to the output file.
%
% DECLARATIONTYPE is one of the Bertini types such as 'variable_group'. If
% it is a cell array, declarations are printed with one line per element of
% the array.
%
% TERMINATOR is one of '' (empty string) or ';'.

if ~iscell(vars) % Make sure it's a cell array of POLYSYM objects 
    vars = {vars};
end

format = ['%s %s',terminator,'\n'];
for ii=1:length(vars)
    % strtrim removes any leading blanks (for when declarationType is
    % empty)
    if ~isempty(vars{ii})
        p = vars{ii};
        str = strtrim(sprintf(format,declarationType,format_array(p(:).',', ')));
        fprintf(fid,'%s\n',str);
    end
end
