function ismember = membership(poly_system,points)
%MEMBERSHIP Find which components a point belongs to.
%
% ismember = poly_system.membership(points) inputs points, a
% numeric/polysym/sym array with one column per point or a structure with a
% field name for each variable. Returns ISMEMBER, a logical array with a column for
% each point and a row for each component. A given element is marked
% true if that point is in that component.
%
% MEMBERSHIP does not store the diagnostic output from Bertini. To see this
% output displayed in the command window, set the property VIEW_PROGRESS
% to TRUE.
%
% Example:
%     polysyms x y z
%     poly_system = BertiniLab('function_def',[x*z+y; y*z+x], ...
%         'variable_group',[x y z]);
%     poly_system = poly_system.irreducible_decomposition;
%     ismember = poly_system.membership([0 0 pi].');
%
% See also: irreducible_decomposition

poly_system.member_points = points;
poly_system.config.TrackType = 3;

ps = poly_system.solve;
membership_info = ps.read_incidence_matrix;
ismember = membership_info.ismember;