function sstruct = match_solutions(poly_system,filename,varargin)
%MATCH_SOLUTIONS Match values of solutions with the variable names
%
% sols = poly_system.match_solutions(filename) inputs the name of a Bertini
% output file and returns a structure. Each field is named after a variable
% and its value is an array of solutions for that variable. Vectors and
% matrices are placed in arrays of appropriate dimensions, with one column
% per vector and one page per matrix.
%
% Example:
%   poly_system = BertiniLab('variable_group','x','function_def','x^2-1');
%   poly_system = solve(poly_system);
%   data = poly_system.match_solutions('raw_solutions');
%
% See also: solve, read_solutions, read_raw_data

% Read in data
sols = poly_system.read_solutions(filename);

% Convert to structure
sstruct = poly_system.mat2struct(sols);
