function fname = make_param_file(poly_sys,params,fname)
%MAKE_PARAM_FILE Create a parameter input file such start_parameter.
%
% fname = poly_sys.make_param_file(param,fname) inputs PARAMS, a
% numeric/polysym/sym vector; and FNAME, the name of the file. If PARAMS is
% nonempty, creates the file with the data formatted for reading by Bertini
% and returns the full path name of the file in FNAME. Otherwise, just
% returns an empty string for FNAME.
%
% MAKE_PARAM_FILE is used to create the files start_parameters and
% final_parameters.
%

if ~isempty(params)
      
    fid = fopen(poly_sys.fullname(fname),'w');

    n = numel(params);
    fprintf(fid,'%d\n\n',n);
    
    params = polysym(params(:));
    [re,im] = real_imag(params);
    c = cellstr(format_array([re im]));
    fprintf(fid,'%s\n',c{:});
    fclose(fid);
    
else
    fname = '';
end